unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ExtCtrls;

type
  TForm1 = class(TForm)
    Image1: TImage;
    Panel1: TPanel;
    CheckBoxSTRETCH: TCheckBox;
    Panel2: TPanel;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    BitBtn3: TBitBtn;
    procedure BitBtn1Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure CheckBoxSTRETCHClick(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);

  private

  public
    procedure Start1();
    procedure Start2();
  end;

var
  Form1: TForm1;

implementation
{$R *.dfm}
{------------------------------------------------------------------------------}
procedure TForm1.BitBtn1Click(Sender: TObject);
begin
	Close();
end;

procedure TForm1.BitBtn2Click(Sender: TObject);
begin
	Start1();
end;

procedure TForm1.BitBtn3Click(Sender: TObject);
begin
	Start2();
end;

procedure TForm1.CheckBoxSTRETCHClick(Sender: TObject);
begin
	if(CheckBoxSTRETCH.Checked) then
   begin
   	Image1.Stretch := true;
   end
   else begin
   	Image1.Stretch := false;
   end;
end;

procedure TForm1.FormCreate(Sender: TObject);
var
	fn : String;

begin
	fn := 'trawa.bmp';
	Image1.Picture.LoadFromFile(fn);
end;

procedure TForm1.Start1();
var
	source : TBitmap;
	dest   : TBitmap;

   x      : Integer;
   y      : Integer;

begin
	source := Graphics.TBitmap.Create();
	source.Assign(Image1.Picture.Bitmap);
	source.PixelFormat := Image1.Picture.Bitmap.PixelFormat;

	dest             := Graphics.TBitmap.Create();
	dest.Width       := source.Height;
	dest.Height      := source.Width;
	dest.PixelFormat := source.PixelFormat;

   // obr jeden pixel na raz - metoda wolniejsza
   for x := 0 to source.Width-1 do
   begin
      for y := 0 to source.Height-1 do
      begin
         dest.Canvas.Pixels[y, source.Width-1-x] := source.Canvas.Pixels[x, y];
      end;
   end;

   Image1.Picture.Bitmap := dest;

   FreeAndNil(dest);
   FreeAndNil(source);
end;

procedure TForm1.Start2();
type
	(*
   typedef struct tagRGBTRIPLE {
   BYTE rgbtBlue;
   BYTE rgbtGreen;
   BYTE rgbtRed;
   } RGBTRIPLE
   *)
	TPixels = Array[WORD] of RGBTRIPLE;
	PPixels = ^TPixels;

var
	source : TBitmap;
	dest   : TBitmap;
   x      : Integer;
   y      : Integer;

 	pixels : PPixels;

   kolor  : TColor;

   iRed   : Byte;
	iGreen : Byte;
   iBlue  : Byte;

begin
	source := Graphics.TBitmap.Create();
	source.Assign(Image1.Picture.Bitmap);
	source.PixelFormat := Image1.Picture.Bitmap.PixelFormat;

	dest             := Graphics.TBitmap.Create();                  	
	dest.Width       := source.Height;
	dest.Height      := source.Width;
	dest.PixelFormat := source.PixelFormat;

   for y := source.Height-1 downto 0 do
   begin
      pixels := source.ScanLine[y];

      for x := source.Width-1 downto 0 do
      begin
         iRed   := Pixels[x].rgbtRed;
         iGreen := Pixels[x].rgbtGreen;
         iBlue  := Pixels[x].rgbtBlue;

         kolor := RGB(iRed, iGreen, iBlue);

         dest.Canvas.Pixels[y, source.Width-1-x] := kolor;
      end;
   end;

   Image1.Picture.Bitmap := dest;

   FreeAndNil(dest);
   FreeAndNil(source);
end;

end.

